// LS_DlgSetQueryLog.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "LS_DlgSetQueryLog.h"
#include "CLS_NVDSDK_Interface.h"


#define LOG_PAGE_SIZE	20
#define TEST_COUNT 2

// CLS_DlgSetQueryLog Ի

IMPLEMENT_DYNAMIC(CLS_DlgSetQueryLog, CDialog)

CLS_DlgSetQueryLog::CLS_DlgSetQueryLog(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_DlgSetQueryLog::IDD, pParent)
{
	m_iLogonID = -1;
	m_iChannelNo = -1;
	m_iCurrentPage = 0;
	m_iTotalFiles = 0;
	m_iTotalPages = 0;
}

CLS_DlgSetQueryLog::~CLS_DlgSetQueryLog()
{
}

void CLS_DlgSetQueryLog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_SET_DVR_LOGTYPE, m_cboLogType);
	DDX_Control(pDX, IDC_CBO_SET_DVR_LANGUAGE, m_cboLanguage);
	DDX_Control(pDX, IDC_LIST_SET_DVR_LOG, m_ctlListDVRLog);
	DDX_Control(pDX, IDC_DTP_SET_DVR_START_TIME, m_dtpBeginTime);
	DDX_Control(pDX, IDC_DTP_SET_DVR_END_TIME, m_dtpEndTime);
	DDX_Control(pDX, IDC_DTP_SET_DVR_START_DATE, m_dtpBeginDate);
	DDX_Control(pDX, IDC_DTP_SET_DVR_END_DATE, m_dtpEndDate);
	DDX_Control(pDX, IDC_CBO_CHANNEL, m_cboChannelNo);
	DDX_Control(pDX, IDC_COMBO_LOG_WRITE_TYPE, m_cboLogWriteType);
}

void CLS_DlgSetQueryLog::Initialize(TDECPARAM* _pdecParam)
{
	if(_pdecParam != NULL)
	{
		UI_UpdateDialog();
		UI_UpdateLogCount();
		UI_UpdateTimeRange();
	}
}


BEGIN_MESSAGE_MAP(CLS_DlgSetQueryLog, CDialog)
	ON_BN_CLICKED(IDC_BTN_QUERY, &CLS_DlgSetQueryLog::OnBnClickedBtnQuery)
	ON_BN_CLICKED(IDC_BTN_SET_DVR_FIRST_PAGE, &CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrFirstPage)
	ON_BN_CLICKED(IDC_BTN_SET_DVR_PRE_PAGE, &CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrPrePage)
	ON_BN_CLICKED(IDC_BTN_SET_DVR_NEXT_PAGE, &CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrNextPage)
	ON_BN_CLICKED(IDC_BTN_SET_DVR_LAST_PAGE, &CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrLastPage)
	ON_BN_CLICKED(IDC_BUTTON_SEND, &CLS_DlgSetQueryLog::OnBnClickedBtnSend)
END_MESSAGE_MAP()


// CLS_DlgSetQueryLog Ϣ
void CLS_DlgSetQueryLog::OnChannelChanged( int _iLogonID,int _iChannelNo,int /*_iStreamNo*/ )
{
	m_iLogonID = _iLogonID;
	m_iChannelNo = _iChannelNo;
	if (m_iLogonID < 0)
	{
		return;
	}
	if (m_iChannelNo == -1)
	{
		m_iChannelNo = 0xFF;
	}

	//UI_UpdateLogCount();
	UI_UpdateTimeRange();

	m_ctlListDVRLog.DeleteAllItems();
	m_iCurrentPage = 0;
	m_iTotalPages = 0;
	m_iTotalFiles = 0;
	SetDlgItemInt(IDC_STC_SHOW_SET_DVR_LOG_NUM, m_iTotalFiles);
	SetDlgItemInt(IDC_STC_SHOW_SET_DVR_PAGE_NUM, m_iTotalPages);
	SetDlgItemInt(IDC_STC_SET_SHOW_DVR_CURRENT_PAGE, m_iCurrentPage);
}

void CLS_DlgSetQueryLog::UI_UpdateTimeRange()
{
	SYSTEMTIME BeginDate;
	SYSTEMTIME BeginTime;
	SYSTEMTIME EndDate;
	SYSTEMTIME EndTime;

	GetLocalTime(&BeginDate);
	GetLocalTime(&BeginTime);
	GetLocalTime(&EndDate);
	GetLocalTime(&EndTime);

	BeginTime.wHour = 0;
	BeginTime.wMinute = 0;
	BeginTime.wSecond = 0;
	m_dtpBeginDate.SetTime(&BeginDate);
	m_dtpBeginTime.SetTime(&BeginTime);
	m_dtpEndDate.SetTime(&EndDate);
	m_dtpEndTime.SetTime(&EndTime);
}

void CLS_DlgSetQueryLog::OnLanguageChanged( int _iLanguage )
{
	UI_UpdateDialog();
	UI_UpdateLogCount();
}

void CLS_DlgSetQueryLog::UI_UpdateDialog()
{
	InsertColumn(m_ctlListDVRLog,0,GetText(IDS_CFG_LOG_DVR_ID),LVCFMT_LEFT,60);
	InsertColumn(m_ctlListDVRLog,1,GetText(IDS_CFG_LOG_DVR_CHANNEL),LVCFMT_LEFT,60);
	InsertColumn(m_ctlListDVRLog,2,GetText(IDS_CFG_LOG_DVR_LOGTYPE),LVCFMT_LEFT,80);
	InsertColumn(m_ctlListDVRLog,3,GetText(IDS_CFG_LOG_DVR_BEGINTIME),LVCFMT_LEFT,130);
	InsertColumn(m_ctlListDVRLog,4,GetText(IDS_CFG_LOG_DVR_ACCOUNT),LVCFMT_LEFT,60);
	InsertColumn(m_ctlListDVRLog,5,GetText(IDS_CFG_LOG_DVR_LOGCONTENT),LVCFMT_LEFT,300);

	SetDlgItemText(IDC_STC_SET_DVR_LOGTYPE, GetText(IDS_CFG_LOG_DVR_LOGTYPE));
	SetDlgItemText(IDC_STC_SET_DVR_LANGUAGE, GetText(IDS_CFG_LOG_DVR_LANGUAGE) );
	SetDlgItemText(IDC_STC_SET_DVR_START_TIME, GetText(IDS_CFG_LOG_DVR_BEGIN) );
	SetDlgItemText(IDC_STC_SET_DVR_END_TIME, GetText(IDS_CFG_LOG_DVR_END));
	SetDlgItemText(IDC_BTN_QUERY, GetText(IDS_CFG_LOG_DVR_QUERY));
	SetDlgItemText(IDC_STC_SET_DVR_LOG_NUM, GetText(IDS_CFG_LOG_DVR_LOGTOTALS));
	SetDlgItemText(IDC_STC_SET_DVR_PAGE_NUM, GetText(IDS_CFG_LOG_DVR_LOGPAGES));
	SetDlgItemText(IDC_STC_SET_DVR_CURRENT_PAGE, GetText(IDS_CFG_LOG_DVR_CURRENTPAGE));
	SetDlgItemText(IDC_BTN_SET_DVR_FIRST_PAGE, GetText(IDS_CFG_LOG_DVR_FIRSTPAGE));
	SetDlgItemText(IDC_BTN_SET_DVR_PRE_PAGE, GetText(IDS_CFG_LOG_DVR_PREPAGE));
	SetDlgItemText(IDC_BTN_SET_DVR_NEXT_PAGE, GetText(IDS_CFG_LOG_DVR_NEXTPAGE));
	SetDlgItemText(IDC_BTN_SET_DVR_LAST_PAGE, GetText(IDS_CFG_LOG_DVR_LASTPAGE));
	m_cboLanguage.ResetContent();
	m_cboLanguage.AddString(GetText(IDS_CFG_LOG_DVR_ENGLISH));
	m_cboLanguage.AddString(GetText(IDS_CFG_LOG_DVR_CHINESE));
	m_cboLanguage.AddString(GetText(IDS_CFG_LOG_DVR_CHINESETAIWAN));
	m_cboLanguage.AddString(GetText(IDS_CFG_LOG_DVR_KOREAN));
	m_cboLanguage.AddString(GetText(IDS_CFG_LOG_DVR_SPANISHECUADOR));
	m_cboLanguage.AddString(GetText(IDS_CFG_LOG_DVR_ITALIAN));
	m_cboLanguage.SetCurSel(0);	
	m_cboLogType.ResetContent();
	m_cboLogType.AddString(GetText(IDS_CFG_LOG_DVR_SYSTEM));
	m_cboLogType.AddString(GetText(IDS_CFG_LOG_DVR_WARNING));
	m_cboLogType.AddString(GetText(IDS_CFG_LOG_DVR_ALARM));
	m_cboLogType.AddString(GetText(IDS_CFG_LOG_DVR_OPERATION));
	m_cboLogType.AddString(GetText(IDS_CFG_LOG_DVR_USER));
	m_cboLogType.AddString(GetText(IDS_CFG_LOG_DVR_OTHER));
	m_cboLogType.AddString(GetText(IDS_CFG_LOG_DVR_ALL));
	m_cboLogType.SetCurSel(6);

	int iRet = CreateChannelCombo(m_iLogonID, &m_cboChannelNo);
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
		return;
	}
	//bool blUsedChannel[DEC_MAX_CHANNEL_NUM_NEW ] = {false};
	//bool blUsedScreen[DEC_MAX_VIRTUAL_CHANNEL_NUM] = {false};
	//int iIndexChannel = 0;
	//int iIndexSysChannel = 0;
	//CreateVVOInfo strCreateVVOInfo = {0};
	//strCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	//int iRet = -1;
	//for (int i=0; i<DEC_MAX_VIRTUAL_CHANNEL_NUM; i++)
	//{
	//	BaseOffset tGetStartAddress;
	//	iRet = DEC_ClientGetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
	//		&tGetStartAddress, sizeof(BaseOffset));
	//	if(iRet < 0)
	//	{
	//		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	//		continue;
	//	}
	//	strCreateVVOInfo.iVVOChannelNo = i + tGetStartAddress.iSplitScreen;
	//	iRet = DEC_ClientGetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &strCreateVVOInfo, sizeof(CreateVVOInfo));
	//	if(iRet < 0)
	//	{
	//		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_CREATE_VVO] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	//		continue;
	//	}

	//	int iUsedNum = strCreateVVOInfo.iCols * strCreateVVOInfo.iRows;

	//	if (iUsedNum > 0)
	//	{
	//		blUsedScreen[i] = true;
	//	}

	//	for (int j=0; j<iUsedNum; j++)
	//	{
	//		if (0 <= strCreateVVOInfo.iInputChannel[j] && strCreateVVOInfo.iInputChannel[j] < DEC_MAX_CHANNEL_NUM_NEW)
	//		{
	//			blUsedChannel[strCreateVVOInfo.iInputChannel[j]] = true;
	//		}
	//	}
	//}

	//BaseOffset tGetStartAddress;
	//iRet = DEC_ClientGetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
	//	&tGetStartAddress, sizeof(BaseOffset));
	//if(iRet < 0)
	//{
	//	AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	//}
	//tDevInfo tDevInfomation = {0};
	//CString strChanel;
	//iRet = DEC_ClientGetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInfomation, sizeof(tDevInfo));
	//if(iRet < 0)
	//{
	//	AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_DEV_INFO] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	//}
	//m_cboChannelNo.ResetContent();
	//for (int i=0; i<tDevInfomation.iChanNum; ++i)
	//{
	//	if (!blUsedChannel[i])
	//	{
	//		strChanel.Format(_T("%d"),i+1);
	//		iIndexSysChannel = m_cboChannelNo.AddString(strChanel);
	//		m_cboChannelNo.SetItemData(iIndexSysChannel, i);
	//	}
	//}


	////ƴͨ
	//for (int i=0; i<DEC_MAX_VIRTUAL_CHANNEL_NUM; i++)
	//{
	//	if (blUsedScreen[i])
	//	{
	//		strChanel.Format(_T("%d"),i + tGetStartAddress.iSplitScreen);
	//		iIndexSysChannel = m_cboChannelNo.AddString(strChanel);
	//		m_cboChannelNo.SetItemData(iIndexSysChannel, i + tGetStartAddress.iSplitScreen);
	//	}
	//}

	//m_cboChannelNo.SetCurSel(0);
}

void CLS_DlgSetQueryLog::UI_UpdateLogCount()
{
	int iTotalCount = 0;
	int iCurrentCount = 0;
	m_ctlListDVRLog.DeleteAllItems();
	int iRet = DEC_ClientNetLogGetLogCount(m_iLogonID, &iTotalCount, &iCurrentCount);
	if(iRet < 0)
	{
		AddLog(LOG_TYPE_FAIL,"","NetLogGetLogCount Error!LogonID(%d)",m_iLogonID);
	}
	else
	{
		UpdateLogFiles( iTotalCount, iCurrentCount);
	}
}

void CLS_DlgSetQueryLog::UpdateLogFiles(int _iTotal, int _iCount)
{   
	m_iTotalFiles = _iTotal;
	SetDlgItemInt(IDC_STC_SHOW_SET_DVR_LOG_NUM, _iTotal);
	int iTotalPages = (_iTotal/LOG_PAGE_SIZE) + ((_iTotal%LOG_PAGE_SIZE==0)?0:1);
	SetDlgItemInt(IDC_STC_SHOW_SET_DVR_PAGE_NUM, iTotalPages);
	m_iTotalPages = iTotalPages;
	SetDlgItemInt(IDC_STC_SET_SHOW_DVR_CURRENT_PAGE, m_iCurrentPage + 1);

	for (int i=1; i< m_ctlListDVRLog.GetItemCount(); i++)
	{
		m_ctlListDVRLog.DeleteItem(i);
	}

	DecLogData logInfo = {0};
	for (int i = 0; i < _iCount; i++)
	{
		memset(&logInfo, 0, sizeof(logInfo));

		if(0 == DEC_ClientNetLogGetLogfile(m_iLogonID, i, &logInfo, sizeof(logInfo)))
		{
			int iCellID = m_iCurrentPage*LOG_PAGE_SIZE + i+1;
			if (iCellID <= _iTotal)
			{
				CString strCellID;
				CString strChannelNo;
				CString strLogType;
				CString strStartTime;

				int iColumn = 0;
				strCellID.Format("%d", iCellID);
				strChannelNo.Format("%d", logInfo.iChannel);
				m_ctlListDVRLog.InsertItem(i, "", _iCount);
				m_ctlListDVRLog.SetItemText(i, iColumn++, strCellID.GetBuffer());

				if (logInfo.iLogType == 0)
				{
					m_ctlListDVRLog.SetItemText(i, iColumn++, "");
				}
				else
				{
					m_ctlListDVRLog.SetItemText(i, iColumn++, strChannelNo);
				}

				if (logInfo.iLogType==0)
				{
					strLogType=GetTextEx(IDS_CFG_LOG_DVR_SYSTEM);
				} 
				else if (logInfo.iLogType==1)
				{
					strLogType=GetTextEx(IDS_CFG_LOG_DVR_WARNING);
				}
				else if (logInfo.iLogType==2)
				{
					strLogType=GetTextEx(IDS_CFG_LOG_DVR_ALARM);
				}
				else if (logInfo.iLogType==3)
				{
					strLogType=GetTextEx(IDS_CFG_LOG_DVR_OPERATION);
				}
				else if (logInfo.iLogType==4)
				{
					strLogType=GetTextEx(IDS_CFG_LOG_DVR_USER);
				}
				else if (logInfo.iLogType==5)
				{
					strLogType=GetTextEx(IDS_CFG_LOG_DVR_ALL);
				}
				else
				{
					strLogType=GetTextEx(IDS_CFG_LOG_DVR_ALL);
				}
				m_ctlListDVRLog.SetItemText(i, iColumn++, strLogType);

				m_ctlListDVRLog.SetItemText(i, iColumn++, TimeToCString(logInfo.struStartTime));

				CString strAccount;
				CString strContent;
				char *pcContent = strstr(logInfo.cLogContent,"@");
				if (pcContent)
				{
					*pcContent = '\0';
					strAccount = logInfo.cLogContent;
					strContent = pcContent+1;
				}
				else
				{
					strContent = logInfo.cLogContent;
				}
				m_ctlListDVRLog.SetItemText(i, iColumn++, strAccount);
				m_ctlListDVRLog.SetItemText(i, iColumn++, strContent);
			}
		}
		else
		{
			AddLog(LOG_TYPE_FAIL,"","etLogGetLogfile Error!LogonID(%d)",m_iLogonID);
		}
	}
}

CString  CLS_DlgSetQueryLog::TimeToCString(NVS_FILE_TIME _nvsTime)
{
	CString strMsg;
	strMsg.Format("%04d/%02d/%02d-%02d:%02d:%02d", _nvsTime.iYear, _nvsTime.iMonth, _nvsTime.iDay, _nvsTime.iHour, _nvsTime.iMinute, _nvsTime.iSecond);
	return strMsg;
}

BOOL CLS_DlgSetQueryLog::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO:  Add extra initialization here

	m_ctlListDVRLog.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	UI_UpdateDialog();

	m_cboLogWriteType.AddString("4001");
	m_cboLogWriteType.AddString("4002");
	m_cboLogWriteType.AddString("4003");
	m_cboLogWriteType.AddString("4004");
	m_cboLogWriteType.SetCurSel(0);
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CLS_DlgSetQueryLog::OnBnClickedBtnQuery()
{
	// TODO: ڴӿؼ֪ͨ
	if (m_cboLogType.GetCurSel() == -1 || m_cboLanguage.GetCurSel() == -1)
		return;

	m_iCurrentPage = 0;
	int iLogType = m_cboLogType.GetCurSel();
	if (6 == iLogType)
	{
		iLogType = 0xFF;
	}

	int iLanguage = m_cboLanguage.GetCurSel();

	m_logQuery.iChannelNo = 0xFF;//GetDlgItemInt(IDC_CBO_CHANNEL);
	m_logQuery.iLogType = iLogType;
	m_logQuery.iLanguage = iLanguage;
	m_logQuery.iPageSize = LOG_PAGE_SIZE;
	m_logQuery.iPageNo = 0;
	m_logQuery.iPageSize = 20;
	m_logQuery.iPageNo = 0;

	unsigned short usTmp = 0;
	SYSTEMTIME BeginDate;
	SYSTEMTIME BeginTime;
	SYSTEMTIME EndDate;
	SYSTEMTIME EndTime;
	m_dtpBeginDate.GetTime(&BeginDate);
	m_logQuery.struStartTime.iYear = BeginDate.wYear;
	m_logQuery.struStartTime.iMonth = BeginDate.wMonth;
	m_logQuery.struStartTime.iDay = BeginDate.wDay;
	m_dtpBeginTime.GetTime(&BeginTime);
	m_logQuery.struStartTime.iHour = BeginTime.wHour;
	m_logQuery.struStartTime.iMinute = BeginTime.wMinute;
	m_logQuery.struStartTime.iSecond = BeginTime.wSecond;
	m_dtpEndDate.GetTime(&EndDate);
	m_logQuery.struStopTime.iYear = EndDate.wYear;
	m_logQuery.struStopTime.iMonth = EndDate.wMonth;
	m_logQuery.struStopTime.iDay = EndDate.wDay;
	m_dtpEndTime.GetTime(&EndTime);
	m_logQuery.struStopTime.iHour = EndTime.wHour;
	m_logQuery.struStopTime.iMinute = EndTime.wMinute;
	m_logQuery.struStopTime.iSecond = EndTime.wSecond;

	int iTimeFlag = 0;		//־ѯ־ʼʱ>ʱ䣬Ὣֵ1
	if (BeginDate.wYear > EndDate.wYear)
	{
		iTimeFlag = 1;
	}
	else
	{
		if (BeginDate.wYear == EndDate.wYear)
		{
			if (BeginDate.wMonth > EndDate.wMonth)
			{
				iTimeFlag = 1;
			}
			else
			{
				if (BeginDate.wMonth == EndDate.wMonth)
				{
					if (BeginDate.wDay > EndDate.wDay)
					{
						iTimeFlag = 1;
					}
					else
					{
						if (BeginDate.wDay == EndDate.wDay)
						{
							if (BeginTime.wHour > EndTime.wHour)
							{
								iTimeFlag = 1;
							}
							else
							{
								if (BeginTime.wHour == EndTime.wHour)
								{
									if (BeginTime.wMinute > EndTime.wMinute)
									{
										iTimeFlag = 1;
									}
									else
									{
										if (BeginTime.wMinute == EndTime.wMinute)
										{
											if (BeginTime.wSecond > EndTime.wSecond)
											{
												iTimeFlag = 1;
											}
											else
											{
												if (BeginTime.wSecond == EndTime.wSecond)
												{
													iTimeFlag = 2;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	if (iTimeFlag == 1)
	{
		MessageBox(GetTextEx(IDS_CONFIG_DVRLOG_TIMEMSG_LATER),GetTextEx(IDS_CONFIG_PROMPT),MB_OK);
		return;
	}
	else if (iTimeFlag == 2)
	{
		MessageBox(GetTextEx(IDS_CONFIG_DVRLOG_TIMEMSG_EQUAL),GetTextEx(IDS_CONFIG_PROMPT),MB_OK);
		return;
	}
	int iRet = DEC_ClientNetLogQuery(m_iLogonID, &m_logQuery,sizeof(m_logQuery));
	if (iRet < 0)
	{
		AddLog(LOG_TYPE_FAIL,"","NetLogQuery Error!LogonID(%d)",m_iLogonID);
	}
	else
	{
		AddLog(LOG_TYPE_SUCC,"","NetLogQuery Success!LogonID(%d)",m_iLogonID);
	}
}

void CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrFirstPage()
{
	// TODO: ڴӿؼ֪ͨ
	if(m_iCurrentPage > 0)
	{
		m_iCurrentPage = 0;
		m_logQuery.iPageNo = m_iCurrentPage;
		m_logQuery.iChannelNo = 0xff;
		int iRet = DEC_ClientNetLogQuery(m_iLogonID, &m_logQuery,sizeof(m_logQuery));
		if (iRet < 0)
		{
			AddLog(LOG_TYPE_FAIL,"","NetLogQuery Error!LogonID(%d)",m_iLogonID);
		}
		else
		{
			AddLog(LOG_TYPE_SUCC,"","NetLogQuery Success!LogonID(%d)",m_iLogonID);
		}
	}
}

void CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrPrePage()
{
	// TODO: ڴӿؼ֪ͨ
	if(m_iCurrentPage > 0)
	{
		m_iCurrentPage--;
		m_logQuery.iPageNo = m_iCurrentPage;
		m_logQuery.iChannelNo = 0xff;
		int iRet = DEC_ClientNetLogQuery(m_iLogonID, &m_logQuery, sizeof(m_logQuery));
		if (iRet < 0)
		{
			AddLog(LOG_TYPE_FAIL,"","NetLogQuery Error!LogonID(%d)",m_iLogonID);
		}
		else
		{
			AddLog(LOG_TYPE_SUCC,"","NetLogQuery Success!LogonID(%d)",m_iLogonID);
		}
	}
}

void CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrNextPage()
{
	// TODO: ڴӿؼ֪ͨ
	if(m_iCurrentPage+1 < m_iTotalPages)
	{
		m_iCurrentPage++;
		m_logQuery.iPageNo = m_iCurrentPage;
		m_logQuery.iChannelNo = 0xff;
		int iRet = DEC_ClientNetLogQuery(m_iLogonID, &m_logQuery, sizeof(m_logQuery));
		if (iRet < 0)
		{
			AddLog(LOG_TYPE_FAIL,"","NetLogQuery Error!LogonID(%d)",m_iLogonID);
		}
		else
		{
			AddLog(LOG_TYPE_SUCC,"","NetLogQuery Success!LogonID(%d)",m_iLogonID);
		}
		::Sleep(100);
	}
}

void CLS_DlgSetQueryLog::OnBnClickedBtnSetDvrLastPage()
{
	// TODO: ڴӿؼ֪ͨ
	if(m_iCurrentPage+1 < m_iTotalPages)
	{
		m_iCurrentPage = m_iTotalPages - 1;
		m_logQuery.iPageNo = m_iCurrentPage;
		m_logQuery.iChannelNo = 0xff;
		int iRet = DEC_ClientNetLogQuery(m_iLogonID, &m_logQuery, sizeof(m_logQuery));
		if (iRet < 0)
		{
			AddLog(LOG_TYPE_FAIL,"","NetLogQuery Error!LogonID(%d)",m_iLogonID);
		}
		else
		{
			AddLog(LOG_TYPE_SUCC,"","NetLogQuery Success!LogonID(%d)",m_iLogonID);
		}
	}
}

void CLS_DlgSetQueryLog::OnMainNotify(_MAIN_NOTIFY_DATA* _pData)
{
	int iType = _pData->m_iMsg;
	if (DEC_WCM_QUERY_LOG_FINISH == iType)
	{
		UI_UpdateLogCount();
	}
	else
	{

	}
}

void CLS_DlgSetQueryLog::OnBnClickedBtnSend()
{
	DecLogWrite tDecLogWrite = {0};
	tDecLogWrite.iSize = sizeof(DecLogWrite);
	tDecLogWrite.iLogType = GetDlgItemInt(IDC_COMBO_LOG_WRITE_TYPE);
	tDecLogWrite.iCount = TEST_COUNT;
	CString strParam1;
	CString strParam2;
	GetDlgItemText(IDC_EDIT_PARAM1, strParam1);
	GetDlgItemText(IDC_EDIT_PARAM2, strParam2);
	strncpy(tDecLogWrite.cParam[0], strParam1.GetBuffer(), LEN_64 - 1);
	strncpy(tDecLogWrite.cParam[1], strParam2.GetBuffer(), LEN_64 - 1);

	int iRet = DEC_ClientSendCommand(m_iLogonID, 0, 0, DEC_COMMAND_LOGWRITE, &tDecLogWrite, tDecLogWrite.iSize);
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_DEBUG,"DEC_ClientSendCommand failed");
	}
	
}